<?php 
define('DOC_ROOT_PATH', $_SERVER['DOCUMENT_ROOT'].'/');
require DOC_ROOT_PATH . $this->config->item('header');
?>

<!-- App Header -->
<div class="appHeader">
    <div class="left">
        <a href="#" class="headerButton goBack">
            <ion-icon name="chevron-back-outline"></ion-icon>
        </a>
    </div>
    <div class="pageTitle">
        Transaction Detail
    </div>
    <div class="right">
        
    </div>
</div>
<!-- * App Header -->


<!-- App Capsule -->
<div id="appCapsule" class="full-height">

    <div class="section mt-2 mb-2">


        <div class="listed-detail mt-3">
            <div class="icon-wrapper">
                <div class="iconbox" style="background-color:#1DCC70 !important;">
                    <ion-icon name="checkmark-circle"></ion-icon>
                </div>
            </div>
            <h3 class="text-center mt-2">Payment Success</h3>
        </div>

        <?php foreach ($get_detail_transaction as $row) {?>
            <ul class="listview flush transparent simple-listview no-space mt-3">
                <li>
                    <strong>Status</strong>
                    <span class="text-success">Success</span>
                </li>
                <li>
                    <strong>No Invoice</strong>
                    <span><?php echo $row['transaction_inv']; ?></span>
                </li>
                <li>
                    <strong>Tanggal</strong>
                    <span><?php $date = date_create($row['transaction_date']);  echo date_format($date,"d-m-Y"); ?></span>
                </li>
                <li>
                    <strong>No Meja</strong>
                    <span><?php echo $row['transaction_table']; ?></span>
                </li>
                <li>
                    <strong>Jam</strong>
                    <span><?php echo $row['transaction_end_time']; ?></span>
                </li>
                <li>
                    <strong>Nominal</strong>
                    <span class="text-success"><?php echo 'Rp. '.number_format($row['transaction_total_bill']) ?></span>
                </li>
                <li>
                    <strong>Jenis Pembayaran</strong>
                    <span><?php echo $row['payment_name']; ?></span>
                </li>
            </ul>
            <?php } ?>


        </div>

    </div>
    <!-- * App Capsule -->


    <?php 
    require DOC_ROOT_PATH . $this->config->item('botmenu');
    ?>


</body>

</html>