<?php
defined('BASEPATH') OR exit('No direct script access allowed');
header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Methods: GET, OPTIONS");
date_default_timezone_set('Asia/Jakarta');
require 'vendor/autoload.php';

use Dompdf\Dompdf;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Report extends CI_Controller {

	public function __construct(){
		parent::__construct();
		$this->load->helper('url');
		$this->load->library('session');
		$this->load->model('api_model');
		$this->load->model('global_model');
		$this->load->helper(array('url', 'html'));
	}

	public function index()
	{
		if(isset($_SESSION['user_name']) != null){
			$get_today_transaction['get_today_transaction'] = $this->api_model->get_today_transaction();
			$this->load->view('Pages/report', $get_today_transaction);
		}else{
			redirect('Dashboard/Admin', 'refresh');
		}
	}

	public function download()
	{

		$start_date = $this->input->post('dateform');
		$end_date   = $this->input->post('dateend');
		$excel = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
		$sheet = $excel->getActiveSheet();

		$sheet->setCellValue('A1', "Laporan Transaksi Billing"); // Set kolom A1 dengan tulisan "DATA SISWA"
    	$sheet->mergeCells('A1:I1'); // Set Merge Cell pada kolom A1 sampai E1
    	$sheet->getStyle('A1')->getFont()->setBold(true);
    	$sheet->getStyle('A3:I3')->getFont()->setBold(true);

    	$sheet->getStyle('A1')->getAlignment()->setHorizontal('center');
    	$sheet->getStyle('A3:I3')->getAlignment()->setHorizontal('center');

    	// Buat header tabel nya pada baris ke 3
    	$sheet->setCellValue('A3', "No Invoice"); 
    	$sheet->setCellValue('B3', "Tanggal"); 
    	$sheet->setCellValue('C3', "Jam Selesai");
    	$sheet->setCellValue('D3', "Mode"); 
    	$sheet->setCellValue('E3', "Promo");
    	$sheet->setCellValue('F3', "Pembayaran");
    	$sheet->setCellValue('G3', "Meja");
    	$sheet->setCellValue('H3', "Total");
    	$sheet->setCellValue('I3', "Kasir");

    	

    	$get_transaction_excell = $this->api_model->get_transaction_excell($start_date, $end_date);
    	$get_transaction_excell_count = $this->api_model->get_transaction_excell_count($start_date, $end_date);

    	$get_transaction_excell_cafe = $this->api_model->get_transaction_excell_cafe($start_date, $end_date);
    	$get_transaction_excell_count_cafe = $this->api_model->get_transaction_excell_count_cafe($start_date, $end_date);

    	if($get_transaction_excell_count != null){

    		$total_row = $get_transaction_excell_count[0]['total_row'] + 5;
    		$total_transaction_all = $get_transaction_excell_count[0]['total_all_transaction'];

    		$sheet->setCellValue('G'.$total_row, "Total Transaksi Billing");
    		$sheet->setCellValue('H'.$total_row, $total_transaction_all);

    		$sheet->getStyle('G'.$total_row)->getFont()->setBold(true);
    		$sheet->getStyle('H'.$total_row)->getFont()->setBold(true);
    	}else{
    		$total_row = 5;
    	}
    	

    	$sheet->setCellValue('A'.$total_row + 6, "Laporan Transaksi Cafe"); // Set kolom A1 dengan tulisan "DATA SISWA"
    	$sheet->mergeCells('A'.($total_row + 6).':I'.($total_row + 6)); // Set Merge Cell pada kolom A1 sampai E1
    	$sheet->getStyle('A'.$total_row + 6)->getFont()->setBold(true);
    	$sheet->getStyle('A'.($total_row + 6).':I'.($total_row + 6))->getFont()->setBold(true);

    	$sheet->getStyle('A1')->getAlignment()->setHorizontal('center');
    	$sheet->getStyle('A3:I3')->getAlignment()->setHorizontal('center');

    	$sheet->setCellValue('A'.$total_row + 7, "No Invoice"); 
    	$sheet->setCellValue('B'.$total_row + 7, "Tanggal"); 
    	$sheet->setCellValue('C'.$total_row + 7, "Pembayaran");
    	$sheet->setCellValue('D'.$total_row + 7, "Total"); 
    	$sheet->setCellValue('E'.$total_row + 7, "Kasir");

    	
    	$i = 4;

    	foreach($get_transaction_excell as $row){
    		$sheet->setCellValue('A'.$i, $row['transaction_inv'] ); 
    		$sheet->setCellValue('B'.$i, $row['transaction_date']);
    		$sheet->setCellValue('C'.$i, $row['transaction_end_time']); 
    		$sheet->setCellValue('D'.$i, $row['transaction_mode']);
    		$sheet->setCellValue('E'.$i, $row['member_name']);
    		$sheet->setCellValue('F'.$i, 'CASH');
    		$sheet->setCellValue('G'.$i, $row['transaction_table']);
    		$sheet->setCellValue('H'.$i, $row['transaction_total_bill']);
    		$sheet->setCellValue('I'.$i, $row['user_name']);
    		$i++;
    	}


    	$j = $total_row + 8;

    	foreach($get_transaction_excell_cafe as $row){
    		$sheet->setCellValue('A'.$j, $row['transaction_inv'] ); 
    		$sheet->setCellValue('B'.$j, $row['transaction_date']);
    		$sheet->setCellValue('C'.$j, $row['transaction_payment_type']); 
    		$sheet->setCellValue('D'.$j, $row['transaction_total']);
    		$sheet->setCellValue('E'.$j, $row['user_name']);
    		$j++;
    	}

    	if($get_transaction_excell_count != null){

    		$total_row_cafe = $get_transaction_excell_count_cafe[0]['total_row_cafe'] + 9 + $total_row;
    		$total_transaction_all_cafe = $get_transaction_excell_count_cafe[0]['total_all_transaction_cafe'];

    		$sheet->setCellValue('G'.$total_row_cafe, "Total Transaksi Cafe");
    		$sheet->setCellValue('H'.$total_row_cafe, $total_transaction_all_cafe);

    		$sheet->getStyle('C'.$total_row_cafe)->getFont()->setBold(true);
    		$sheet->getStyle('D'.$total_row_cafe)->getFont()->setBold(true);
    	}

    	$sheet->getColumnDimension('A')->setWidth(55); 
    	$sheet->getColumnDimension('B')->setWidth(35); 
    	$sheet->getColumnDimension('C')->setWidth(35);
    	$sheet->getColumnDimension('D')->setWidth(35);
    	$sheet->getColumnDimension('E')->setWidth(35);
    	$sheet->getColumnDimension('F')->setWidth(35);
    	$sheet->getColumnDimension('G')->setWidth(35);
    	$sheet->getColumnDimension('H')->setWidth(35);
    	$sheet->getColumnDimension('I')->setWidth(35);

    	$sheet->getStyle('D')->getNumberFormat()->setFormatCode('#,##0');
    	$sheet->getStyle('H')->getNumberFormat()->setFormatCode('#,##0');

	    // Set height semua kolom menjadi auto (mengikuti height isi dari kolommnya, jadi otomatis)
	    //$sheet->getDefaultRowDimension()->setRowHeight(-1);
	    // Set orientasi kertas jadi LANDSCAPE


    	$sheet->getPageSetup()->setOrientation(\PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_LANDSCAPE);
	    // Set judul file excel nya
    	$sheet->setTitle("Excell");

    	ob_end_clean();
    	
    	
    	header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    	header('Content-Disposition: attachment;filename="Laporan_transaksi' .date('Y-m-d') . '.xlsx"');
    	header('Cache-Control: max-age=0');

    	$xlsxWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($excel, 'Xlsx');
    	$xlsxWriter = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($excel);
    	$xlsxWriter->save("php://output");
    }

    public function get_transaction_total()
    {
    	$dateform = $this->input->post('dateform');
    	$dateend  = $this->input->post('dateend');
    	$get_transaction_total_billing = $this->api_model->get_transaction_total_print_billing($dateform, $dateend);
    	$get_transaction_total_cafe = $this->api_model->get_transaction_total_print_cafe($dateform, $dateend);
    	echo json_encode(['code'=>200, 'billing'=>$get_transaction_total_billing, 'cafe'=>$get_transaction_total_cafe]);
    	die();
    }

}

?>