<?php
ob_start();
defined('BASEPATH') OR exit('No direct script access allowed');
header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Headers: Content-Type, Content-Length, Accept-Encoding");
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method, Authorization");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");

class apiol extends CI_Controller {

	public function __construct(){
		parent::__construct();
		$this->load->helper('url');
		$this->load->library('session');
		$this->load->model('api_model');
		$this->load->helper(array('url', 'html'));
		date_default_timezone_set('Asia/Jakarta');
	}

	public function recive_transaction()
	{
		$data 				   = json_decode(file_get_contents('php://input'), true);
		foreach($data['header'] as $row_header)
		{
			$header = array(
				'transaction_inv' 	       => $row_header['transaction_inv'],
				'transaction_date' 		   => $row_header['transaction_date'],
				'transaction_mode'   	   => $row_header['transaction_mode'],
				'transaction_member_id'    => $row_header['transaction_member_id'],
				'transaction_start_time'   => $row_header['transaction_start_time'],
				'transaction_end_time'	   => $row_header['transaction_end_time'],
				'transaction_duration'	   => $row_header['transaction_duration'],
				'transaction_sub_total'	   => $row_header['transaction_sub_total'],
				'transaction_discount'	   => $row_header['transaction_discount'],
				'transaction_total_bill'   => $row_header['transaction_total_bill'],
				'transaction_table'	       => $row_header['transaction_table'],
				'transaction_status'       => $row_header['transaction_status'],
				'created_at'	           => $row_header['created_at'],
				'created_by'			   => $row_header['created_by'],
				'paid_by'				   => $row_header['paid_by'],
			);
			$this->api_model->insert_transaction_header($header);
		}
		foreach($data['detail'] as $row_detail)
		{
			$detail = array(
				'transaction_detail_invoice'  => $row_detail['transaction_detail_invoice'],
				'item_name'   	              => $row_detail['item_name'],
				'price'   					  => $row_detail['price'],
				'qty'	   					  => $row_detail['qty'],
				'sift'	                      => $row_detail['sift'],
			);
			$this->api_model->insert_transaction_detail($detail);
		}
		echo '200'; die();
	}

	public function recive_table_live()
	{
		$data 				   = json_decode(file_get_contents('php://input'), true);
		foreach($data['live_table'] as $row){
			$table_id = $row['table_id'];
			$update = array(
				'table_mode' 	       => $row['table_mode'],
				'table_start_time'     => $row['table_start_time'],
				'table_end_time'       => $row['table_end_time'],
				'table_duration'	   => $row['table_duration'],
				'table_bill'	       => (int)$row['table_bill'],
				'table_invoice'        => $row['table_invoice'],
				'table_active'         => (int)$row['table_active'],
				'is_active'            => (int)$row['is_active']
			);
			$this->api_model->update_book_table($update, $table_id);
		}
		echo '200'; die();
	}

	public function recive_user()
	{
		$data 				   = json_decode(file_get_contents('php://input'), true);
		$this->api_model->delete_user();
		foreach($data['user'] as $row){
			$insert = array(
				'user_id' 	      => $row['user_id'],
				'user_name'       => $row['user_name'],
				'user_pass'       => $row['user_pass'],
				'user_role'	      => $row['user_role'],
				'is_active'	      => (int)$row['is_active'],
				'created_at'      => $row['created_at'],
			);
			$this->api_model->insert_user($insert);
		}
		echo '200'; die();
	}

	public function recive_stock()
	{
		$data 				   = json_decode(file_get_contents('php://input'), true);
		$this->api_model->delete_product();
		foreach($data['product'] as $row){
			$insert = array(
				'product_id' 	       => $row['product_id'],
				'category_id' 	       => $row['category_id'],
				'unit_id'         	   => $row['unit_id'],
				'product_code'     	   => $row['product_code'],
				'product_name'	       => $row['product_name'],
				'product_cogs'	       => (int)$row['product_cogs'],
				'product_price'        => (int)$row['product_price'],
				'product_image'        => $row['product_buy_price'],
				'product_stock'        => (int)$row['product_sell_price'],
				'reduce_stock'         => $row['product_reduce_stock'],
				'is_active'	           => $row['is_active'],
			);
			$this->api_model->insert_proudct($insert);
		}
		echo '200'; die();
	}


	public function recive_transaction_cafe()
	{
		$data 				   = json_decode(file_get_contents('php://input'), true);
		foreach($data['header'] as $row_header)
		{
			$header = array(
				'transaction_inv' 	       => $row_header['transaction_inv'],
				'transaction_table' 	   => $row_header['transaction_date'],
				'transaction_date'   	   => $row_header['transaction_mode'],
				'transaction_payment_type' => $row_header['transaction_member_id'],
				'transaction_sub_total'    => $row_header['transaction_start_time'],
				'transaction_tax'	       => $row_header['transaction_end_time'],
				'transaction_promo'	       => $row_header['transaction_duration'],
				'transaction_total'	       => $row_header['transaction_sub_total'],
				'transaction_user_id'	   => $row_header['transaction_discount'],
				'transaction_waiters_id'   => $row_header['transaction_total_bill'],
				'created_at'	           => $row_header['transaction_table'],
				'transaction_print'        => $row_header['transaction_status'],
				'kitchen_print'	           => $row_header['created_at']
			);
			$this->api_model->insert_transaction_cafe_header($header);
		}
		foreach($data['detail'] as $row_detail)
		{
			$detail = array(
				'transaction_inv'  			  		=> $row_detail['transaction_inv'],
				'transaction_detail_product_id'   	=> $row_detail['transaction_detail_product_id'],
				'transaction_detail_qty'   			=> $row_detail['transaction_detail_qty'],
				'transaction_detail_price'	   		=> $row_detail['transaction_detail_price'],
				'transaction_detail_total'	        => $row_detail['transaction_detail_total'],
				'transaction_user_id'	            => $row_detail['transaction_user_id']
			);
			$this->api_model->insert_transaction_cafe_detail($detail);
		}
		echo '200'; die();
	}

	public function recive_user_cafe()
	{
		$data 				   = json_decode(file_get_contents('php://input'), true);
		$this->api_model->delete_user_cafe();
		foreach($data['user'] as $row){
			$insert = array(
				'user_id' 	      => $row['user_id'],
				'user_name'       => $row['user_name'],
				'user_password'   => $row['user_password'],
				'user_role'	      => $row['user_role'],
				'user_active'	  => (int)$row['user_active'],
				'created_at'      => $row['created_at'],
			);
			$this->api_model->insert_user_cafe($insert);
		}
		echo '200'; die();
	}


}

